package com.qboxus.tictic.activitesfragments.spaces.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.qboxus.tictic.models.UserModel;

import java.io.Serializable;

public class HomeUserModel implements Parcelable {
    public UserModel userModel;
    public String userRoleType,mice,riseHand,online;

    public HomeUserModel() {
        mice="0";
        riseHand="0";
        online="0";
    }

    protected HomeUserModel(Parcel in) {
        userModel = in.readParcelable(UserModel.class.getClassLoader());
        userRoleType = in.readString();
        mice = in.readString();
        riseHand = in.readString();
        online = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(userModel, flags);
        dest.writeString(userRoleType);
        dest.writeString(mice);
        dest.writeString(riseHand);
        dest.writeString(online);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<HomeUserModel> CREATOR = new Creator<HomeUserModel>() {
        @Override
        public HomeUserModel createFromParcel(Parcel in) {
            return new HomeUserModel(in);
        }

        @Override
        public HomeUserModel[] newArray(int size) {
            return new HomeUserModel[size];
        }
    };

    public String getRiseHand() {
        return riseHand;
    }

    public void setRiseHand(String riseHand) {
        this.riseHand = riseHand;
    }

    public UserModel getUserModel() {
        return userModel;
    }

    public void setUserModel(UserModel userModel) {
        this.userModel = userModel;
    }

    public String getUserRoleType() {
        return userRoleType;
    }

    public String getMice() {
        return mice;
    }

    public void setMice(String mice) {
        this.mice = mice;
    }

    public void setUserRoleType(String userRoleType) {
        this.userRoleType = userRoleType;
    }

    public String getOnline() {
        return online;
    }

    public void setOnline(String online) {
        this.online = online;
    }
}
